# coding:utf-8
import os
from Crypto.Cipher import AES
import binascii
# 给定的密钥和IV
key_hex = "3082046C30820354A003020102020900"
iv_hex = "11132123313341435153616667687172"

# 读取二进制文件内容
def read_binary_file(file_path):
    with open(file_path, 'rb') as file:
        return file.read()

# 写入解密后的文件内容
def write_binary_file(file_path, data):
    with open(file_path, 'wb') as file:
        file.write(data)

# 将十六进制字符串转换为字节
def hex_to_bytes(hex_str):
    return binascii.unhexlify(hex_str)

# AES-CTR解密函数
def aes_ctr_decrypt(ciphertext, key, iv):
    cipher = AES.new(key, AES.MODE_CTR, nonce=iv[:8], initial_value=iv[8:])
    return cipher.decrypt(ciphertext)

# 将密钥和IV转换为字节
key = hex_to_bytes(key_hex)
iv = hex_to_bytes(iv_hex)
 
files = [f for f in os.listdir(".\in") if os.path.isfile(os.path.join(".\in", f))]
for file in files:
    # 读取二进制文件内容
    ciphertext = read_binary_file(os.path.join(".\in", file))
    # 解密文件
    plaintext = aes_ctr_decrypt(ciphertext, key, iv)
    # 将解密后的内容写入新文件
    output_file_path = os.path.join(".\out", file.replace(".lsa",".jpg"))
    write_binary_file(output_file_path, plaintext)
    print(f"{file}解密完成->{output_file_path}")
